//--------------
// un-tweaks
//--------------
   float4x4 ViewProj:ViewProjection;
   float4x4 View:View;
   float4x4 ViewInv:ViewInverse;

//--------------
// tweaks
//--------------
   float2 Aspect;

//--------------
// Textures
//--------------
   texture ParticleTexture <string Name = "";>;	
   sampler ParticleSampler=sampler_state 
      {
 	Texture=<ParticleTexture>;
      };
   texture ColorTexture <string Name = "";>;	
   sampler ColorSampler=sampler_state 
      {
 	Texture=<ColorTexture>;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };
   texture CurvatureTexture <string Name = "";>;	
   sampler CurvatureSampler=sampler_state 
      {
 	Texture=<CurvatureTexture>;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };
   texture PixelTexture <string Name = "";>;	
   sampler PixelSampler=sampler_state 
      {
 	Texture=<PixelTexture>;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };
   texture PixelPreviousTexture <string Name = "";>;	
   sampler PixelPreviousSampler=sampler_state 
      {
 	Texture=<PixelPreviousTexture>;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float3 Pos:POSITION;	
	float2 Tex0:TEXCOORD0;
 	float2 Tex1:TEXCOORD1;
 	float2 Tex2:TEXCOORD2;
 	float2 Tex3:TEXCOORD3;
 	float2 Tex4:TEXCOORD4;
 	float2 Tex5:TEXCOORD5;
 	float2 Tex6:TEXCOORD6;
 	float3 Color:COLOR0;
     };
   struct OutPut
     {
	float4 Pos:POSITION;
	float4 Tex:TEXCOORD0;
	float Frame:TEXCOORD1;
	float4 Color:TEXCOORD2;
	float Emissive:TEXCOORD3;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	float2 Pixel=floor(float2(IN.Pos.z,IN.Pos.z/254));
	Pixel=float2((Pixel.x-Pixel.y*254.0)-256.0,Pixel.y+256.0)*0.00390625;
	float4 Particle=tex2Dlod(PixelSampler,Pixel.xyyy);
	float4 ParticlePrev=tex2Dlod(PixelPreviousSampler,Pixel.xyyy);
	float3 WorldPos=Particle.xyz*IN.Tex5.x;
        float3 Curve=tex2Dlod(CurvatureSampler,float4(Particle.w,(IN.Tex6.x+0.5)/1024.0,0,0));
        float2 Size=(IN.Pos.xy*IN.Tex1.x)*Curve.y;
        float Strobe=saturate(sin(Particle.w*IN.Tex4.x).xx+0.5);
        Size +=Strobe*(IN.Pos.xy*IN.Tex3.y)*Curve.z;
        float4 CurrPos=mul(float4(Particle.xyz*IN.Tex5.x,1.0),ViewProj);
        float4 PrevPos=mul(float4(ParticlePrev.xyz*IN.Tex5.x,1.0),ViewProj);
        PrevPos.xy=(CurrPos.xy-PrevPos.xy)/Aspect;
        Size *=1.0+CurrPos.z*IN.Tex2.x;
        float DirLength=1.0+(length(PrevPos.xy*IN.Tex1.y)/ParticlePrev.w);
        float Angle=lerp(IN.Tex2.y+(Particle.w*IN.Tex3.x),atan2(PrevPos.x/CurrPos.w,PrevPos.y/CurrPos.w),sign(IN.Tex1.y));
        Size=mul(float2(Size.x,Size.y*DirLength*DirLength),float2x2(cos(Angle),-sin(Angle),sin(Angle),cos(Angle)));
        WorldPos +=mul(float4(Size*IN.Tex5.x ,0.0,0.0),ViewInv).xyz;
        OUT.Pos=mul(float4(WorldPos*saturate(ceil(Particle.w*ParticlePrev.w)),1.0),ViewProj);
	float2 UV=float2(IN.Pos.x,-IN.Pos.y)*0.5+0.5;
	float FrameTime=IN.Tex0.x*IN.Tex0.y;
	FrameTime *=Particle.w*(1.0-(1.0/FrameTime));
	OUT.Tex.xy=(UV/IN.Tex0.xy)+(float2(int(FrameTime),int(FrameTime/IN.Tex0.x))/IN.Tex0);
 	OUT.Tex.zw=(UV/IN.Tex0.xy)+(float2(int(FrameTime+1),int((FrameTime+1)/IN.Tex0.x))/IN.Tex0);
	OUT.Frame=FrameTime-floor(FrameTime);
	OUT.Color=tex2Dlod(ColorSampler,float4(Particle.w,(IN.Tex6.x+0.5)/1024.0,0,0));
	OUT.Color.xyz=pow(OUT.Color.xyz+IN.Color,2.2);
	OUT.Emissive=IN.Tex4.y*Curve.x;
	return OUT;
     }

//--------------
// pixel shader
//--------------
    float4 PS(OutPut IN)  : COLOR
     {
        float4 Particle=lerp(tex2D(ParticleSampler,IN.Tex.xy),tex2D(ParticleSampler,IN.Tex.zw),IN.Frame);
        Particle.xyz=pow(Particle.xyz,2.2)*IN.Color.xyz;
	return float4(Particle.xyz+Particle.xyz*IN.Emissive,Particle.w*IN.Color.w);
     }

//--------------
// techniques   
//--------------
   technique Particles
      {
 	pass p0
      {		
	vertexShader= compile vs_3_0 VS();
 	pixelShader = compile ps_3_0 PS();
	AlphaBlendEnable=true;
	AlphaTestEnable=false;
	zwriteenable=false;
      }
      }

